"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.linkAtomic = void 0;
const fs_1 = require("fs");
const util_1 = require("../utils/util");
const move_1 = require("./move");
/**
 * Creates a hard file link atomically.
 * @function linkAtomic
 * @memberof fsn/nextra
 * @param source The source path of the file
 * @param destination The destination path of the file
 */
async function linkAtomic(source, destination) {
    const tempPath = util_1.tempFile();
    await fs_1.promises.link(source, tempPath);
    await move_1.move(tempPath, destination, { overwrite: true });
}
exports.linkAtomic = linkAtomic;
//# sourceMappingURL=linkAtomic.js.map