"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.gzipAtomic = void 0;
const gzip_1 = require("./gzip");
const move_1 = require("./move");
const util_1 = require("../utils/util");
/**
 * Gzips a file atomically.
 * @function gzipAtomic
 * @memberof fsn/nextra
 * @param fileName The filename of the archive
 * @param inputFile The filepath of the input file
 */
async function gzipAtomic(fileName, inputFile) {
    const tempPath = util_1.tempFile();
    await gzip_1.gzip(tempPath, inputFile);
    return move_1.move(tempPath, fileName, { overwrite: true });
}
exports.gzipAtomic = gzipAtomic;
//# sourceMappingURL=gzipAtomic.js.map