"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.gzip = void 0;
const zlib_1 = require("zlib");
const fs_1 = require("fs");
const util_1 = require("../utils/util");
const gzipAtomic_1 = require("./gzipAtomic");
/**
 * Gzips a file
 * @function gzip
 * @memberof fsn/nextra
 * @param fileName The filename of the archive
 * @param inputFile The filepath of the input file
 * @param atomic If the gzip file should be created
 */
async function gzip(fileName, inputFile, atomic = false) {
    if (atomic)
        return gzipAtomic_1.gzipAtomic(fileName, inputFile);
    return util_1.pipelinePromise(fs_1.createReadStream(inputFile), zlib_1.createGzip(), fs_1.createWriteStream(fileName));
}
exports.gzip = gzip;
//# sourceMappingURL=gzip.js.map