"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.gunzipAtomic = void 0;
const gunzip_1 = require("./gunzip");
const move_1 = require("./move");
const util_1 = require("../utils/util");
/**
 * Un-Gzips a file atomically.
 * @function gunzipAtomic
 * @memberof fsn/nextra
 * @param fileName The filename of the output file
 * @param inputFile The filepath of the archive
 */
async function gunzipAtomic(fileName, inputFile) {
    const tempPath = util_1.tempFile();
    await gunzip_1.gunzip(tempPath, inputFile);
    return move_1.move(tempPath, fileName, { overwrite: true });
}
exports.gunzipAtomic = gunzipAtomic;
//# sourceMappingURL=gunzipAtomic.js.map