"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.gunzip = void 0;
const zlib_1 = require("zlib");
const fs_1 = require("fs");
const util_1 = require("../utils/util");
const gunzipAtomic_1 = require("./gunzipAtomic");
/**
 * Un-Gzips a file
 * @function gunzip
 * @memberof fsn/nextra
 * @param fileName The filename of the output file
 * @param inputFile The filepath of the archive
 * @param atomic If the unzip file should be created atomically
 */
async function gunzip(fileName, inputFile, atomic = false) {
    if (atomic)
        return gunzipAtomic_1.gunzipAtomic(fileName, inputFile);
    return util_1.pipelinePromise(fs_1.createReadStream(inputFile), zlib_1.createGunzip(), fs_1.createWriteStream(fileName));
}
exports.gunzip = gunzip;
//# sourceMappingURL=gunzip.js.map