"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.emptydir = exports.emptyDir = void 0;
const path_1 = require("path");
const fs_1 = require("fs");
const mkdirs_1 = require("./mkdirs");
const remove_1 = require("./remove");
/**
 * Deletes all directories and files within the provided directory.
 * @function emptydir
 * @memberof fsn/nextra
 * @param dir The directory you wish to empty
 */
/**
 * Deletes all directories and files within the provided directory.
 * @function emptyDir
 * @memberof fsn/nextra
 * @param dir The directory you wish to empty
 */
async function emptyDir(dir) {
    try {
        const items = await fs_1.promises.readdir(dir);
        await Promise.all(items.map((item) => remove_1.remove(path_1.join(dir, item))));
    }
    catch (err) {
        await mkdirs_1.mkdirs(dir);
    }
}
exports.emptyDir = emptyDir;
exports.emptydir = emptyDir;
//# sourceMappingURL=emptyDir.js.map