"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ensureSymlinkAtomic = exports.createSymlinkAtomic = void 0;
const createSymlink_1 = require("./createSymlink");
/**
 * Creates a soft file link, making all folders required to satisfy the given file path atomically.
 * @function ensureSymlinkAtomic
 * @memberof fsn/nextra
 * @param {string} source The source path of the file
 * @param {string} destination The destination path of the file
 * @param {SymLinkType} type The type of symlink you are creating
 * @returns {Promise<void>}
 */
/**
 * Creates a soft file link, making all folders required to satisfy the given file path atomically.
 * @function createSymlinkAtomic
 * @memberof fsn/nextra
 * @param {string} source The source path of the file
 * @param {string} destination The destination path of the file
 * @param {SymLinkType} type The type of symlink you are creating
 * @returns {Promise<void>}
 */
function createSymlinkAtomic(source, destination, type) {
    return createSymlink_1.createSymlink(source, destination, type, true);
}
exports.createSymlinkAtomic = createSymlinkAtomic;
exports.ensureSymlinkAtomic = createSymlinkAtomic;
//# sourceMappingURL=createSymlinkAtomic.js.map