"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ensureSymlink = exports.createSymlink = void 0;
const path_1 = require("path");
const fs_1 = require("fs");
const pathExists_1 = require("./pathExists");
const mkdirs_1 = require("./mkdirs");
const symlinkAtomic_1 = require("./symlinkAtomic");
async function createSymlink(source, destination, type, atomic = false) {
    if (await pathExists_1.pathExists(destination))
        return;
    if (typeof type === 'boolean')
        [atomic, type] = [type, undefined];
    await mkdirs_1.mkdirs(path_1.dirname(destination));
    const relativePath = await symlinkPaths(source, destination);
    const symlinkMethod = atomic ? symlinkAtomic_1.symlinkAtomic : fs_1.promises.symlink;
    await symlinkMethod(relativePath.toDst, path_1.resolve(destination), type || await symlinkType(relativePath.toCwd));
}
exports.createSymlink = createSymlink;
async function symlinkPaths(srcpath, dstPath) {
    if (path_1.isAbsolute(srcpath)) {
        await fs_1.promises.lstat(srcpath);
        return { toCwd: srcpath, toDst: srcpath };
    }
    const dstDir = path_1.dirname(dstPath);
    const relativeToDst = path_1.join(dstDir, srcpath);
    /* istanbul ignore next: Doesn't get tested on all OSs */
    if (await pathExists_1.pathExists(relativeToDst))
        return { toCwd: relativeToDst, toDst: srcpath };
    await fs_1.promises.lstat(srcpath);
    return { toCwd: srcpath, toDst: path_1.relative(dstDir, srcpath) };
}
async function symlinkType(srcpath) {
    const stats = await fs_1.promises.lstat(srcpath);
    return stats.isDirectory() ? 'dir' : 'file';
}
exports.ensureSymlink = createSymlink;
//# sourceMappingURL=createSymlink.js.map