/**
 * The type of symlink you are creating:
 * * `dir`
 * * `file`
 * * `junction`
 * @typedef {string} SymLinkType
 * @memberof fsn/nextra
 */
export declare type SymLinkType = 'dir' | 'file' | 'junction';
/**
 * Creates a soft file link, making all folders required to satisfy the given file path.
 * @function ensureSymlink
 * @memberof fsn/nextra
 * @param source The source path of the file
 * @param destination The destination path of the file
 * @param type The type of symlink you are creating
 * @param atomic Whether the operation should run atomically
 */
/**
 * Creates a soft file link, making all folders required to satisfy the given file path.
 * @function createSymlink
 * @memberof fsn/nextra
 * @param source The source path of the file
 * @param destination The destination path of the file
 * @param type The type of symlink you are creating
 * @param atomic Whether the operation should run atomically
 */
export declare function createSymlink(source: string, destination: string, atomic?: boolean): Promise<void>;
export declare function createSymlink(source: string, destination: string, type?: SymLinkType, atomic?: boolean): Promise<void>;
export declare const ensureSymlink: typeof createSymlink;
