"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ensureLinkAtomic = exports.createLinkAtomic = void 0;
const createLink_1 = require("./createLink");
/**
 * Creates a hard file link, making all folders required to satisfy the given file path atomically.
 * @function ensureLinkAtomic
 * @memberof fsn/nextra
 * @param source The source path of the file
 * @param destination The destination path of the file
 */
/**
 * Creates a hard file link, making all folders required to satisfy the given file path atomically.
 * @function createLinkAtomic
 * @memberof fsn/nextra
 * @param source The source path of the file
 * @param destination The destination path of the file
 */
function createLinkAtomic(source, destination) {
    return createLink_1.createLink(source, destination, true);
}
exports.createLinkAtomic = createLinkAtomic;
exports.ensureLinkAtomic = createLinkAtomic;
//# sourceMappingURL=createLinkAtomic.js.map