"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ensureLink = exports.createLink = void 0;
const path_1 = require("path");
const fs_1 = require("fs");
const linkAtomic_1 = require("./linkAtomic");
const mkdirs_1 = require("./mkdirs");
const pathExists_1 = require("./pathExists");
/**
 * Creates a hard file link, making all folders required to satisfy the given file path.
 * @function ensureLink
 * @memberof fsn/nextra
 * @param source The source path of the file
 * @param destination The destination path of the file
 * @param atomic Whether the operation should run atomically
 */
/**
 * Creates a hard file link, making all folders required to satisfy the given file path.
 * @function createLink
 * @memberof fsn/nextra
 * @param source The source path of the file
 * @param destination The destination path of the file
 * @param atomic Whether the operation should run atomically
 */
async function createLink(source, destination, atomic = false) {
    if (await pathExists_1.pathExists(destination))
        return;
    await fs_1.promises.lstat(source);
    await mkdirs_1.mkdirs(path_1.dirname(destination));
    const linkMethod = atomic ? linkAtomic_1.linkAtomic : fs_1.promises.link;
    await linkMethod(source, destination);
}
exports.createLink = createLink;
exports.ensureLink = createLink;
//# sourceMappingURL=createLink.js.map