"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ensureFileCopyAtomic = exports.createFileCopyAtomic = void 0;
const createFileCopy_1 = require("./createFileCopy");
/**
 * Creates a file copy atomically, making all folders required to satisfy the given file path.
 * @function ensureFileCopyAtomic
 * @memberof fsn/nextra
 * @param source The path to the file you want to copy
 * @param destination The path to the file destination
 */
/**
 * Creates a file copy atomically, making all folders required to satisfy the given file path.
 * @function createFileCopyAtomic
 * @memberof fsn/nextra
 * @param source The path to the file you want to copy
 * @param destination The path to the file destination
 */
async function createFileCopyAtomic(source, destination) {
    return createFileCopy_1.createFileCopy(source, destination, true);
}
exports.createFileCopyAtomic = createFileCopyAtomic;
exports.ensureFileCopyAtomic = createFileCopyAtomic;
//# sourceMappingURL=createFileCopyAtomic.js.map