"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ensureFileCopy = exports.createFileCopy = void 0;
const path_1 = require("path");
const fs_1 = require("fs");
const copyFileAtomic_1 = require("./copyFileAtomic");
const mkdirs_1 = require("./mkdirs");
/**
 * Creates an file copy, making all folders required to satisfy the given file path.
 * @function ensureFileCopy
 * @memberof fsn/nextra
 * @param source The path to the file you want to copy
 * @param destination The path to the file destination
 * @param atomic Whether the operation should run atomically
 */
/**
 * Creates an file copy, making all folders required to satisfy the given file path.
 * @function createFileCopy
 * @memberof fsn/nextra
 * @param source The path to the file you want to copy
 * @param destination The path to the file destination
 * @param atomic Whether the operation should run atomically
 */
async function createFileCopy(source, destination, atomic = false) {
    if (path_1.resolve(source) === path_1.resolve(destination)) {
        await fs_1.promises.access(source);
    }
    else {
        await mkdirs_1.mkdirs(path_1.dirname(destination));
        const copyMethod = atomic ? copyFileAtomic_1.copyFileAtomic : fs_1.promises.copyFile;
        await copyMethod(source, destination);
    }
}
exports.createFileCopy = createFileCopy;
exports.ensureFileCopy = createFileCopy;
//# sourceMappingURL=createFileCopy.js.map