"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ensureFile = exports.createFile = void 0;
const path_1 = require("path");
const fs_1 = require("fs");
const writeFileAtomic_1 = require("./writeFileAtomic");
const mkdirs_1 = require("./mkdirs");
const pathExists_1 = require("./pathExists");
/**
 * Creates an empty file, making all folders required to satisfy the given file path.
 * @function ensureFile
 * @memberof fsn/nextra
 * @param file Path of the file you want to create
 * @param atomic Whether the operation should run atomically
 */
/**
 * Creates an empty file, making all folders required to satisfy the given file path.
 * @function createFile
 * @memberof fsn/nextra
 * @param file Path of the file you want to create
 * @param atomic Whether the operation should run atomically
 */
async function createFile(file, atomic = false) {
    if (await pathExists_1.pathExists(file))
        return;
    await mkdirs_1.mkdirs(path_1.dirname(file));
    const writeMethod = atomic ? writeFileAtomic_1.writeFileAtomic : fs_1.promises.writeFile;
    await writeMethod(file, '');
}
exports.createFile = createFile;
exports.ensureFile = createFile;
//# sourceMappingURL=createFile.js.map