"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.copyFileAtomic = void 0;
const fs_1 = require("fs");
const util_1 = require("../utils/util");
const move_1 = require("./move");
/**
 * @function copyFileAtomic
 * @memberof fsn/nextra
 * @param source The path to the file you want to copy
 * @param destination The path to the file destination
 * @param options The write options or the encoding string.
 */
async function copyFileAtomic(source, destination) {
    const tempPath = util_1.tempFile();
    await fs_1.promises.copyFile(source, tempPath);
    await move_1.move(tempPath, destination, { overwrite: true });
}
exports.copyFileAtomic = copyFileAtomic;
//# sourceMappingURL=copyFileAtomic.js.map