declare type CopyFilter = (source: string, target: string) => boolean;
/**
 * @typedef {Object} CopyOptions
 * @memberof fsn/nextra
 * @property [filter = undefined] A filter function to determine which files to copy.
 * @property [overwrite = true] Whether to overwrite files or not.
 * @property [preserveTimestamps = true] Whether or not to preserve timestamps on the files.
 * @property [errorOnExist = false] Whether or not to error if the destination exists
 */
export interface CopyOptions {
    filter?: CopyFilter;
    overwrite?: boolean;
    preserveTimestamps?: boolean;
    errorOnExist?: boolean;
}
/**
 * Copies files from one location to another, creating all directories required to satisfy the destination path.
 * @function copy
 * @memberof fsn/nextra
 * @param source The source path
 * @param destination The destination path
 * @param options Options for the copy, or a filter function
 */
export declare function copy(source: string, destination: string, options?: CopyOptions | CopyFilter): Promise<void>;
export {};
