"use strict";
/* istanbul ignore file: Types and Docs for fs-promises, should not test or require coverage */
Object.defineProperty(exports, "__esModule", { value: true });
const fs = require("fs");
var fs_1 = require("fs");
exports.createReadStream = fs_1.createReadStream;
exports.createWriteStream = fs_1.createWriteStream;
exports.unwatchFile = fs_1.unwatchFile;
exports.watch = fs_1.watch;
exports.watchFile = fs_1.watchFile;
exports.Dirent = fs_1.Dirent;
exports.Stats = fs_1.Stats;
exports.ReadStream = fs_1.ReadStream;
exports.WriteStream = fs_1.WriteStream;
exports.constants = fs_1.constants;
/**
 * [fs.promises] Asynchronously tests a user's permissions for the file specified by path.
 * @param path A path to a file or directory. If a URL is provided, it must use the `file:` protocol.
 * URL support is _experimental_.
 */
function access(path, mode) { return fs.promises.access(path, mode); }
exports.access = access;
/**
 * [fs.promises] Asynchronously copies `src` to `dest`. By default, `dest` is overwritten if it already exists.
 * Node.js makes no guarantees about the atomicity of the copy operation.
 * If an error occurs after the destination file has been opened for writing, Node.js will attempt
 * to remove the destination.
 * @param src A path to the source file.
 * @param dest A path to the destination file.
 * @param flags An optional integer that specifies the behavior of the copy operation. The only
 * supported flag is `fs.constants.COPYFILE_EXCL`, which causes the copy operation to fail if
 * `dest` already exists.
 */
function copyFile(src, dest, flags) { return fs.promises.copyFile(src, dest, flags); }
exports.copyFile = copyFile;
/**
 * [fs.promises] Asynchronous open(2) - open and possibly create a file.
 * @param path A path to a file. If a URL is provided, it must use the `file:` protocol.
 * @param mode A file mode. If a string is passed, it is parsed as an octal integer. If not
 * supplied, defaults to `0o666`.
 */
function open(path, flags, mode) { return fs.promises.open(path, flags, mode); }
exports.open = open;
/**
 * [fs.promises] Asynchronously reads data from the file referenced by the supplied `FileHandle`.
 * @param handle A `FileHandle`.
 * @param buffer The buffer that the data will be written to.
 * @param offset The offset in the buffer at which to start writing.
 * @param length The number of bytes to read.
 * @param position The offset from the beginning of the file from which data should be read. If
 * `null`, data will be read from the current position.
 */
function read(handle, buffer, offset, length, position) { return fs.promises.read(handle, buffer, offset, length, position); }
exports.read = read;
function write(handle, data, offsetOrPosition, encodingOrLength) {
    return fs.promises.write(handle, data, offsetOrPosition, encodingOrLength);
}
exports.write = write;
/**
 * [fs.promises] Asynchronous rename(2) - Change the name or location of a file or directory.
 * @param oldPath A path to a file. If a URL is provided, it must use the `file:` protocol.
 * URL support is _experimental_.
 * @param newPath A path to a file. If a URL is provided, it must use the `file:` protocol.
 * URL support is _experimental_.
 */
function rename(oldPath, newPath) {
    return fs.promises.rename(oldPath, newPath);
}
exports.rename = rename;
/**
 * [fs.promises] Asynchronous truncate(2) - Truncate a file to a specified length.
 * @param path A path to a file. If a URL is provided, it must use the `file:` protocol.
 * @param len If not specified, defaults to `0`.
 */
function truncate(path, len) {
    return fs.promises.truncate(path, len);
}
exports.truncate = truncate;
/**
 * [fs.promises] Asynchronous ftruncate(2) - Truncate a file to a specified length.
 * @param handle A `FileHandle`.
 * @param len If not specified, defaults to `0`.
 */
function ftruncate(handle, len) {
    return fs.promises.ftruncate(handle, len);
}
exports.ftruncate = ftruncate;
/**
 * [fs.promises] Asynchronous rmdir(2) - delete a directory.
 * @param path A path to a file. If a URL is provided, it must use the `file:` protocol.
 */
function rmdir(path) {
    return fs.promises.rmdir(path);
}
exports.rmdir = rmdir;
/**
 * Asynchronous fdatasync(2) - synchronize a file's in-core state with storage device.
 * @param handle A `FileHandle`.
 */
function fdatasync(handle) {
    return fs.promises.fdatasync(handle);
}
exports.fdatasync = fdatasync;
/**
 * [fs.promises] Asynchronous fsync(2) - synchronize a file's in-core state with the underlying storage device.
 * @param handle A `FileHandle`.
 */
function fsync(handle) {
    return fs.promises.fsync(handle);
}
exports.fsync = fsync;
/**
 * [fs.promises] Asynchronous mkdir(2) - create a directory.
 * @param path A path to a file. If a URL is provided, it must use the `file:` protocol.
 * @param options Either the file mode, or an object optionally specifying the file mode and whether parent folders
 * should be created. If a string is passed, it is parsed as an octal integer. If not specified, defaults to `0o777`.
 */
function mkdir(path, options) {
    return fs.promises.mkdir(path, options);
}
exports.mkdir = mkdir;
function readdir(path, options) {
    return fs.promises.readdir(path, options);
}
exports.readdir = readdir;
function readlink(path, options) {
    return fs.promises.readlink(path, options);
}
exports.readlink = readlink;
/**
 * [fs.promises] Asynchronous symlink(2) - Create a new symbolic link to an existing file.
 * @param target A path to an existing file. If a URL is provided, it must use the `file:` protocol.
 * @param path A path to the new symlink. If a URL is provided, it must use the `file:` protocol.
 * @param type May be set to `'dir'`, `'file'`, or `'junction'` (default is `'file'`) and is only available on Windows (ignored on other platforms).
 * When using `'junction'`, the `target` argument will automatically be normalized to an absolute path.
 */
function symlink(target, path, type) {
    return fs.promises.symlink(target, path, type);
}
exports.symlink = symlink;
/**
 * [fs.promises] Asynchronous fstat(2) - Get file status.
 * @param handle A `FileHandle`.
 */
function fstat(handle) {
    return fs.promises.fstat(handle);
}
exports.fstat = fstat;
/**
 * [fs.promises] Asynchronous lstat(2) - Get file status. Does not dereference symbolic links.
 * @param path A path to a file. If a URL is provided, it must use the `file:` protocol.
 */
function lstat(path) {
    return fs.promises.lstat(path);
}
exports.lstat = lstat;
/**
 * [fs.promises] Asynchronous stat(2) - Get file status.
 * @param path A path to a file. If a URL is provided, it must use the `file:` protocol.
 */
function stat(path) {
    return fs.promises.stat(path);
}
exports.stat = stat;
/**
 * [fs.promises] Asynchronous link(2) - Create a new link (also known as a hard link) to an existing file.
 * @param existingPath A path to a file. If a URL is provided, it must use the `file:` protocol.
 * @param newPath A path to a file. If a URL is provided, it must use the `file:` protocol.
 */
function link(existingPath, newPath) {
    return fs.promises.link(existingPath, newPath);
}
exports.link = link;
/**
 * [fs.promises] Asynchronous unlink(2) - delete a name and possibly the file it refers to.
 * @param path A path to a file. If a URL is provided, it must use the `file:` protocol.
 */
function unlink(path) {
    return fs.promises.unlink(path);
}
exports.unlink = unlink;
/**
 * [fs.promises] Asynchronous fchmod(2) - Change permissions of a file.
 * @param handle A `FileHandle`.
 * @param mode A file mode. If a string is passed, it is parsed as an octal integer.
 */
function fchmod(handle, mode) {
    return fs.promises.fchmod(handle, mode);
}
exports.fchmod = fchmod;
/**
 * [fs.promises] Asynchronous chmod(2) - Change permissions of a file.
 * @param path A path to a file. If a URL is provided, it must use the `file:` protocol.
 * @param mode A file mode. If a string is passed, it is parsed as an octal integer.
 */
function chmod(path, mode) {
    return fs.promises.chmod(path, mode);
}
exports.chmod = chmod;
/**
 * [fs.promises] Asynchronous lchmod(2) - Change permissions of a file. Does not dereference symbolic links.
 * @param path A path to a file. If a URL is provided, it must use the `file:` protocol.
 * @param mode A file mode. If a string is passed, it is parsed as an octal integer.
 */
function lchmod(path, mode) {
    return fs.promises.lchmod(path, mode);
}
exports.lchmod = lchmod;
/**
 * [fs.promises] Asynchronous lchown(2) - Change ownership of a file. Does not dereference symbolic links.
 * @param path A path to a file. If a URL is provided, it must use the `file:` protocol.
 */
function lchown(path, uid, gid) {
    return fs.promises.lchown(path, uid, gid);
}
exports.lchown = lchown;
/**
 * [fs.promises] Asynchronous fchown(2) - Change ownership of a file.
 * @param handle A `FileHandle`.
 */
function fchown(handle, uid, gid) {
    return fs.promises.fchown(handle, uid, gid);
}
exports.fchown = fchown;
/**
 * [fs.promises] Asynchronous chown(2) - Change ownership of a file.
 * @param path A path to a file. If a URL is provided, it must use the `file:` protocol.
 */
function chown(path, uid, gid) {
    return fs.promises.chown(path, uid, gid);
}
exports.chown = chown;
/**
 * [fs.promises] Asynchronously change file timestamps of the file referenced by the supplied path.
 * @param path A path to a file. If a URL is provided, it must use the `file:` protocol.
 * @param atime The last access time. If a string is provided, it will be coerced to number.
 * @param mtime The last modified time. If a string is provided, it will be coerced to number.
 */
function utimes(path, atime, mtime) {
    return fs.promises.utimes(path, atime, mtime);
}
exports.utimes = utimes;
/**
 * [fs.promises] Asynchronously change file timestamps of the file referenced by the supplied `FileHandle`.
 * @param handle A `FileHandle`.
 * @param atime The last access time. If a string is provided, it will be coerced to number.
 * @param mtime The last modified time. If a string is provided, it will be coerced to number.
 */
function futimes(handle, atime, mtime) {
    return fs.promises.futimes(handle, atime, mtime);
}
exports.futimes = futimes;
function realpath(path, options) {
    return fs.promises.realpath(path, options);
}
exports.realpath = realpath;
function mkdtemp(prefix, options) {
    return fs.promises.mkdtemp(prefix, options);
}
exports.mkdtemp = mkdtemp;
/**
 * [fs.promises] Asynchronously writes data to a file, replacing the file if it already exists.
 * It is unsafe to call `fsPromises.writeFile()` multiple times on the same file without waiting for the `Promise` to be resolved (or rejected).
 * @param path A path to a file. If a URL is provided, it must use the `file:` protocol.
 * URL support is _experimental_.
 * If a `FileHandle` is provided, the underlying file will _not_ be closed automatically.
 * @param data The data to write. If something other than a `Buffer` or `Uint8Array` is provided, the value is coerced to a string.
 * @param options Either the encoding for the file, or an object optionally specifying the encoding, file mode, and flag.
 * If `encoding` is not supplied, the default of `'utf8'` is used.
 * If `mode` is not supplied, the default of `0o666` is used.
 * If `mode` is a string, it is parsed as an octal integer.
 * If `flag` is not supplied, the default of `'w'` is used.
 */
function writeFile(path, data, options) {
    return fs.promises.writeFile(path, data, options);
}
exports.writeFile = writeFile;
/**
 * [fs.promises] Asynchronously append data to a file, creating the file if it does not exist.
 * @param file A path to a file. If a URL is provided, it must use the `file:` protocol.
 * URL support is _experimental_.
 * If a `FileHandle` is provided, the underlying file will _not_ be closed automatically.
 * @param data The data to write. If something other than a `Buffer` or `Uint8Array` is provided, the value is coerced to a string.
 * @param options Either the encoding for the file, or an object optionally specifying the encoding, file mode, and flag.
 * If `encoding` is not supplied, the default of `'utf8'` is used.
 * If `mode` is not supplied, the default of `0o666` is used.
 * If `mode` is a string, it is parsed as an octal integer.
 * If `flag` is not supplied, the default of `'a'` is used.
 */
function appendFile(path, data, options) {
    return fs.promises.appendFile(path, data, options);
}
exports.appendFile = appendFile;
function readFile(path, options) {
    return fs.promises.readFile(path, options);
}
exports.readFile = readFile;
/* eslint-enable max-len */
//# sourceMappingURL=fs.js.map