/**
 * Copyright (c) Facebook, Inc. and its affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 */
import { type ReactNode } from 'react';
import type { PropVersionMetadata } from '@docusaurus/plugin-content-docs';
/**
 * Provide the current version's metadata to your children.
 */
export declare function DocsVersionProvider({ children, version, }: {
    children: ReactNode;
    version: PropVersionMetadata | null;
}): JSX.Element;
/**
 * Gets the version metadata of the current doc page.
 */
export declare function useDocsVersion(): PropVersionMetadata;
//# sourceMappingURL=docsVersion.d.ts.map