# Installation
> `npm install --save @types/gulp-sourcemaps`

# Summary
This package contains type definitions for gulp-sourcemaps (https://github.com/gulp-sourcemaps/gulp-sourcemaps).

# Details
Files were exported from https://github.com/DefinitelyTyped/DefinitelyTyped/tree/master/types/gulp-sourcemaps.
## [index.d.ts](https://github.com/DefinitelyTyped/DefinitelyTyped/tree/master/types/gulp-sourcemaps/index.d.ts)
````ts
// Type definitions for gulp-sourcemaps
// Project: https://github.com/gulp-sourcemaps/gulp-sourcemaps
// Definitions by: Phips Peter <https://github.com/pspeter3>
//                 Concision <https://github.com/concision>
// Definitions: https://github.com/DefinitelyTyped/DefinitelyTyped

/// <reference types="node"/>

import File = require("vinyl");

interface InitOptions {
    loadMaps?: boolean | undefined;
    debug?: boolean | undefined;
}

interface WriteMapper {
    (file: string): string;
}

interface SourceMapMapper {
    (sourcePath: string, file: File): string;
}

interface SourceUrlMapper {
    (file: File): string;
}

interface MapFilenameMapper {
    (mapFilePath: string): string;
}

interface CloneOptions {
    contents?: boolean | undefined;
    deep?: boolean | undefined;
}

interface WriteOptions {
    addComment?: boolean | undefined;
    includeContent?: boolean | undefined;
    sourceRoot?: string | WriteMapper | undefined;
    sourceMappingURLPrefix?: string | WriteMapper | undefined;
    sourceMappingURL?: SourceUrlMapper | undefined;
    destPath?: string | undefined;
    mapFile?: MapFilenameMapper | undefined;
    charset?: BufferEncoding | undefined;
    clone?: boolean | CloneOptions | undefined;
}

export declare function init(opts?: InitOptions): NodeJS.ReadWriteStream;
export declare function mapSources(mapper?: SourceMapMapper): NodeJS.ReadWriteStream;
export declare function write(path?: string, opts?: WriteOptions): NodeJS.ReadWriteStream;
export declare function write(opts?: WriteOptions): NodeJS.ReadWriteStream;

````

### Additional Details
 * Last updated: Wed, 10 May 2023 21:03:35 GMT
 * Dependencies: [@types/node](https://npmjs.com/package/@types/node), [@types/vinyl](https://npmjs.com/package/@types/vinyl)
 * Global values: none

# Credits
These definitions were written by [Phips Peter](https://github.com/pspeter3), and [Concision](https://github.com/concision).
